<?php
session_start();
// Check if the user is an authenticated admin
if (!isset($_SESSION['userRole']) || $_SESSION['userRole'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// NOTE: PHP database logic is not executed in this single-file preview.
// The dashboard card values and table data are hardcoded for demonstration.
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --bg-color-light: #f4f7f9;
            --card-bg-light: #ffffff;
            --text-color-dark: #2c3e50;
            --primary-color: #5b86e5; /* New primary blue */
            --secondary-color: #6c757d;
            --accent-green: #34d399; /* New vibrant green */
            --accent-yellow: #fcd34d; /* New vibrant yellow */
            --accent-blue: #60a5fa; /* New vibrant blue */
            --sidebar-width: 250px;
        }

        body {
            background-color: var(--bg-color-light);
            background-image: linear-gradient(135deg, var(--bg-color-light) 0%, #e0eaf4 100%);
            color: var(--text-color-dark);
            font-family: 'Poppins', sans-serif;
            transition: all 0.3s ease;
        }
        
        /* Top Navigation Bar */
        .navbar-brand {
            font-weight: 700;
        }

        /* Dashboard Cards */
        .dashboard-card {
            background: var(--card-bg-light);
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: none;
        }
        
        .dashboard-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
        }
        
        .icon-box {
            color: #fff;
            border-radius: 12px;
            padding: 1.5rem;
            display: inline-flex;
            justify-content: center;
            align-items: center;
            background-color: var(--primary-color);
            transition: background-color 0.3s ease;
        }

        .icon-box.bg-info { background-color: var(--accent-blue) !important; }
        .icon-box.bg-warning { background-color: var(--accent-yellow) !important; }
        .icon-box.bg-success { background-color: var(--accent-green) !important; }

        .dashboard-card h2 {
            font-weight: 700;
            font-size: 2.5rem;
        }
        
        .chart-container {
            position: relative;
            height: 400px;
        }
        
        /* DataTables Customizations */
        .dataTables_wrapper .dataTables_filter input,
        .dataTables_wrapper .dataTables_length select {
            border: 1px solid #e0eaf4;
            padding: 0.375rem 0.75rem;
            border-radius: 8px;
            color: var(--text-color-dark) !important;
            transition: border-color 0.3s ease;
        }
        
        .dataTables_wrapper .dataTables_filter input:focus,
        .dataTables_wrapper .dataTables_length select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(91, 134, 229, 0.25);
        }

        .dataTables_wrapper .dataTables_info,
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            color: var(--text-color-dark) !important;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            transition: background-color 0.3s ease, transform 0.2s ease;
            border-radius: 8px;
        }
        .btn-primary:hover {
            background-color: #4a77d1;
            transform: translateY(-2px);
        }

        .btn-success, .btn-danger, .btn-secondary {
            border-radius: 8px;
        }

        /* Toast Notifications */
        .toast-container {
            z-index: 1060;
        }

        /* --- Responsive Styles --- */
        #layoutSidenav {
            display: flex;
        }
        #layoutSidenav_nav {
            transform: translateX(-100%);
            transition: transform 0.3s ease-in-out;
            position: fixed;
            top: 56px; /* Height of the top nav */
            bottom: 0;
            z-index: 1030;
            width: var(--sidebar-width);
            background: #2c3e50;
            padding-top: 1rem;
            box-shadow: 0 0 10px rgba(0,0,0,0.2);
        }

        body.sb-sidenav-toggled #layoutSidenav_nav {
            transform: translateX(0);
        }
        
        /* Backdrop for mobile */
        #sidenav-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 1029; /* Just below the sidebar */
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s ease;
        }

        body.sb-sidenav-toggled #sidenav-backdrop {
            opacity: 1;
            pointer-events: auto;
        }

        #layoutSidenav_content {
            flex-grow: 1;
            transition: margin-left 0.3s ease;
        }

        /* Show sidebar on large screens and hide the toggle button */
        @media (min-width: 992px) {
            #layoutSidenav_nav {
                transform: translateX(0);
                position: static;
            }
            #layoutSidenav_content {
                margin-left: var(--sidebar-width);
            }
            .navbar-toggler {
                display: none;
            }
            .navbar .container-fluid {
              padding-left: 2rem;
              padding-right: 2rem;
            }
        }
        
    </style>
</head>
<body class="sb-nav-fixed">
    <!-- Top Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
        <div class="container-fluid">
            <!-- Toggler for mobile sidebar -->
            <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0 d-lg-none" id="sidebarToggle" href="#!"><i class="fas fa-bars"></i></button>
            <a class="navbar-brand d-lg-none" href="#">Admin Dashboard</a>
            
            <!-- Top Nav Links (Visible on desktop) -->
            <ul class="navbar-nav d-none d-lg-flex me-auto">
                <li class="nav-item"><a class="nav-link" href="#">Dashboard</a></li>
                <li class="nav-item"><a class="nav-link" href="#studentTbl">Student Management</a></li>
                <li class="nav-item"><a class="nav-link" href="#courseManagement">Course Management</a></li>
            </ul>
            
            <!-- Navbar Toggler for Collapsible Menu (if any) -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <!-- User Menu -->
            <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-user-circle fa-fw fa-lg"></i></a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <li><a class="dropdown-item" href="#">Settings</a></li>
                        <li><a class="dropdown-item" href="#">Activity Log</a></li>
                        <li><hr class="dropdown-divider" /></li>
                        <li><a class="dropdown-item" href="#">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
    
    <div id="layoutSidenav">
        <!-- Side Navigation Bar -->
        <nav class="sb-sidenav accordion sb-sidenav-dark" id="layoutSidenav_nav">
            <div class="sb-sidenav-menu">
                <div class="nav">
                    <div class="sb-sidenav-menu-heading">Core</div>
                    <a class="nav-link active" href="#">
                        <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                        Dashboard
                    </a>
                    <div class="sb-sidenav-menu-heading">Management</div>
                    <a class="nav-link" href="#studentTbl">
                        <div class="sb-nav-link-icon"><i class="fas fa-user-graduate"></i></div>
                        Student Management
                    </a>
                    <a class="nav-link" href="#courseManagement">
                        <div class="sb-nav-link-icon"><i class="fas fa-book-open"></i></div>
                        Course Management
                    </a>
                </div>
            </div>
        </nav>
        
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid px-4 mt-4">
                    <h1 class="fw-bold mb-4" style="color: var(--text-color-dark);">Admin Dashboard</h1>
                    
                    <!-- Dashboard Cards (PHP data is hardcoded for this single-file example) -->
                    <div class="row g-4 mb-4">
                        <div class="col-lg-4 col-md-6 col-12">
                            <div class="card dashboard-card p-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="text-muted mb-0">Total Students</p>
                                        <h2 class="mt-1" style="color: var(--accent-blue);">125</h2>
                                    </div>
                                    <div class="icon-box bg-info">
                                        <i class="fas fa-users fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-12">
                            <div class="card dashboard-card p-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="text-muted mb-0">Pending Applications</p>
                                        <h2 class="mt-1" style="color: var(--accent-yellow);">7</h2>
                                    </div>
                                    <div class="icon-box bg-warning">
                                        <i class="fas fa-user-plus fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-12">
                            <div class="card dashboard-card p-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="text-muted mb-0">Total Courses</p>
                                        <h2 class="mt-1" style="color: var(--accent-green);">15</h2>
                                    </div>
                                    <div class="icon-box bg-success">
                                        <i class="fas fa-book-open fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Charts Section -->
                    <div class="row g-4 mb-4">
                        <div class="col-lg-6 col-12">
                            <div class="card dashboard-card p-4">
                                <h4 class="fw-bold mb-4" style="color: var(--text-color-dark);">Students by Grade</h4>
                                <div class="chart-container">
                                    <canvas id="gradeChart"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="card dashboard-card p-4">
                                <h4 class="fw-bold mb-4" style="color: var(--text-color-dark);">Students by Status</h4>
                                <div class="chart-container">
                                    <canvas id="statusChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Student Management Table -->
                    <div class="card dashboard-card p-4 mb-4" id="studentTbl">
                        <h4 class="fw-bold mb-4" style="color: var(--text-color-dark);">Student Management</h4>
                        <div class="table-responsive">
                            <table id="studentDataTable" class="table table-hover" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Grade</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <!-- Course Management Section -->
                    <div class="card dashboard-card p-4 mb-4" id="courseManagement">
                        <h4 class="fw-bold mb-4" style="color: var(--text-color-dark);">Course Management</h4>
                        <a href="#" class="btn btn-primary"><i class="fas fa-plus me-2"></i>Add New Course</a>
                    </div>
                </div>
                <!-- Toast Container for Notifications -->
                <div class="toast-container position-fixed bottom-0 end-0 p-3"></div>
            </main>

            <!-- Footer -->
            <footer class="py-4 bg-light mt-auto">
                <div class="container-fluid px-4">
                    <div class="d-flex align-items-center justify-content-between small">
                        <div class="text-muted">Copyright &copy; Your Website 2024</div>
                        <div>
                            <a href="#">Privacy Policy</a>
                            &middot;
                            <a href="#">Terms &amp; Conditions</a>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
    
    <!-- New backdrop for mobile sidebar -->
    <div id="sidenav-backdrop" class="d-lg-none"></div>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $(document).ready(function() {
            // Function to fetch and render charts
            function fetchAndRenderCharts() {
                // Mock data for demonstration since this is a single file
                const mockData = {
                    grades: {
                        "Grade 10": 35,
                        "Grade 11": 45,
                        "Grade 12": 40
                    },
                    status: {
                        approved: 118,
                        pending: 7
                    }
                };
                renderGradeChart(mockData.grades);
                renderStatusChart(mockData.status);
            }

            // Render Grade Chart
            function renderGradeChart(gradeData) {
                const ctx = document.getElementById('gradeChart').getContext('2d');
                new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: Object.keys(gradeData),
                        datasets: [{
                            label: 'Number of Students',
                            data: Object.values(gradeData),
                            backgroundColor: [
                                'rgba(96, 165, 250, 0.8)',
                                'rgba(252, 211, 77, 0.8)',
                                'rgba(52, 211, 153, 0.8)',
                            ],
                            borderColor: [
                                'rgba(96, 165, 250, 1)',
                                'rgba(252, 211, 77, 1)',
                                'rgba(52, 211, 153, 1)',
                            ],
                            borderWidth: 1,
                            borderRadius: 8
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: { color: 'var(--text-color-dark)' },
                                grid: { color: '#e0eaf4' }
                            },
                            x: {
                                ticks: { color: 'var(--text-color-dark)' },
                                grid: { color: '#e0eaf4' }
                            }
                        },
                        plugins: { legend: { display: false } }
                    }
                });
            }

            // Render Status Chart
            function renderStatusChart(statusData) {
                const ctx = document.getElementById('statusChart').getContext('2d');
                new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: ['Approved', 'Pending'],
                        datasets: [{
                            data: [statusData.approved, statusData.pending],
                            backgroundColor: ['rgba(52, 211, 153, 0.8)', 'rgba(252, 211, 77, 0.8)'],
                            hoverOffset: 4
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                labels: { color: 'var(--text-color-dark)' }
                            }
                        }
                    }
                });
            }

            // Initialize DataTables with mock data
            var studentTable = $('#studentDataTable').DataTable({
                "columns": [
                    { "data": "Sid" },
                    { "data": "Sfname", "render": function(data, type, row) { return row.Sfname + " " + row.Slname; } },
                    { "data": "Semail" },
                    { "data": "Sgrade" },
                    {
                        "data": "Sstatus",
                        "render": function(data, type, row) {
                            if (data == 1) {
                                return '<span class="badge bg-success">Approved</span>';
                            } else {
                                return '<span class="badge bg-warning text-dark">Pending</span>';
                            }
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row) {
                            if (row.Sstatus == 0) {
                                return `
                                    <button class="btn btn-success btn-sm approve-btn" data-id="${row.Sid}">Approve</button>
                                    <button class="btn btn-danger btn-sm deny-btn" data-id="${row.Sid}">Deny</button>
                                `;
                            } else {
                                return '<button class="btn btn-secondary btn-sm" disabled>Approved</button>';
                            }
                        }
                    }
                ],
                "data": [
                    { "Sid": 1, "Sfname": "John", "Slname": "Doe", "Semail": "john.doe@example.com", "Sgrade": "Grade 11", "Sstatus": 0 },
                    { "Sid": 2, "Sfname": "Jane", "Slname": "Smith", "Semail": "jane.smith@example.com", "Sgrade": "Grade 12", "Sstatus": 1 },
                    { "Sid": 3, "Sfname": "Peter", "Slname": "Jones", "Semail": "peter.jones@example.com", "Sgrade": "Grade 10", "Sstatus": 0 },
                    { "Sid": 4, "Sfname": "Sarah", "Slname": "Miller", "Semail": "sarah.miller@example.com", "Sgrade": "Grade 11", "Sstatus": 1 },
                    { "Sid": 5, "Sfname": "David", "Slname": "Williams", "Semail": "david.williams@example.com", "Sgrade": "Grade 10", "Sstatus": 1 }
                ]
            });

            // Handle approve and deny button clicks
            $('#studentDataTable tbody').on('click', '.approve-btn', function() {
                var studentId = $(this).data('id');
                showToast(`Student ${studentId} approved!`, 'bg-success');
            });
            $('#studentDataTable tbody').on('click', '.deny-btn', function() {
                var studentId = $(this).data('id');
                showToast(`Student ${studentId} denied.`, 'bg-danger');
            });

            // Toggle sidebar visibility on click
            $('#sidebarToggle').on('click', function(event) {
                event.preventDefault();
                $('body').toggleClass('sb-sidenav-toggled');
            });

            // Close sidebar when clicking the backdrop
            $('#sidenav-backdrop').on('click', function() {
                $('body').removeClass('sb-sidenav-toggled');
            });

            // Custom function to show a toast notification
            function showToast(message, colorClass) {
                const toastHtml = `
                    <div class="toast show ${colorClass} text-white" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="3000">
                        <div class="d-flex">
                            <div class="toast-body">${message}</div>
                            <button type="button" class="btn-close me-2 m-auto btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
                        </div>
                    </div>
                `;
                const toastContainer = $('.toast-container');
                toastContainer.html(toastHtml);
                const newToast = toastContainer.find('.toast');
                const toast = new bootstrap.Toast(newToast[0]);
                toast.show();
            }
            
            // Initial chart rendering
            fetchAndRenderCharts();
        });
    </script>
</body>
</html>
